<?php

namespace App\Modules\Ais\Models\Fir;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sector extends Model 
{

    protected $table = 'ais_fir_sector';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fir_id', 'covered_by');

    public function airports()
    {
        return $this->hasMany('App\Modules\Ais\Models\Airport');
    }

    public function coveredBy()
    {
        return $this->belongsTo('App\Modules\Ais\Models\Fir');
    }

}